/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.gui;

import com.flanks255.simplybackpacks.SimplyBackpacks;
import com.flanks255.simplybackpacks.inventory.FilterItemHandler;
import com.flanks255.simplybackpacks.items.BackpackItem;
import com.flanks255.simplybackpacks.network.FilterMessage;
import com.flanks255.simplybackpacks.network.ToggleMessage;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class FilterContainer
extends AbstractContainerMenu {
    public final FilterItemHandler filterHandler;
    private int slotID;
    private final Player playerEntity;
    private final ItemStack stack;

    public static FilterContainer fromNetwork(int windowId, Inventory playerInventory, FriendlyByteBuf extra) {
        CompoundTag nbt = extra.m_130261_();
        FilterItemHandler handler = new FilterItemHandler();
        handler.deserializeNBT(nbt);
        return new FilterContainer(windowId, playerInventory, handler);
    }

    public FilterContainer(int windowId, Inventory playerInventory, FilterItemHandler handlerIn) {
        super((MenuType)SimplyBackpacks.FILTERCONTAINER.get(), windowId);
        this.playerEntity = playerInventory.f_35978_;
        this.stack = this.findBackpack(this.playerEntity);
        this.filterHandler = handlerIn;
        this.addPlayerSlots(playerInventory);
    }

    public boolean m_6875_(@Nonnull Player playerIn) {
        if (this.slotID == -106) {
            return playerIn.m_21206_().m_41720_() instanceof BackpackItem;
        }
        return playerIn.m_150109_().m_8020_(this.slotID).m_41720_() instanceof BackpackItem;
    }

    private ItemStack findBackpack(Player playerEntity) {
        Inventory inv = playerEntity.m_150109_();
        if (playerEntity.m_21205_().m_41720_() instanceof BackpackItem) {
            for (int i = 0; i <= 8; ++i) {
                ItemStack stack = inv.m_8020_(i);
                if (stack != playerEntity.m_21205_()) continue;
                this.slotID = i;
                return stack;
            }
        } else {
            if (playerEntity.m_21206_().m_41720_() instanceof BackpackItem) {
                this.slotID = -106;
                return playerEntity.m_21206_();
            }
            for (int i = 0; i <= 8; ++i) {
                ItemStack stack = inv.m_8020_(i);
                if (!(stack.m_41720_() instanceof BackpackItem)) continue;
                this.slotID = i;
                return stack;
            }
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public void m_150399_(int slotId, int dragType, @Nonnull ClickType clickTypeIn, @Nonnull Player playerIn) {
        if (slotId >= 0 && this.m_38853_(slotId).m_7993_() == playerIn.m_21205_()) {
            return;
        }
        if (clickTypeIn == ClickType.SWAP) {
            return;
        }
        if (slotId >= 0) {
            this.m_38853_((int)slotId).f_40218_.m_6596_();
        }
        super.m_150399_(slotId, dragType, clickTypeIn, playerIn);
    }

    public int getFilterOpts() {
        return this.stack.m_41784_().m_128451_("Filter-OPT");
    }

    public boolean getPickup() {
        return this.stack.m_41784_().m_128471_("Pickup");
    }

    public boolean togglePickup() {
        CompoundTag nbt = this.stack.m_41784_();
        boolean Pickup = !nbt.m_128471_("Pickup");
        nbt.m_128379_("Pickup", Pickup);
        if (this.playerEntity.m_20193_().f_46443_) {
            SimplyBackpacks.NETWORK.sendToServer((Object)new ToggleMessage());
        }
        return Pickup;
    }

    public int setFilterOpts(int newOpts) {
        CompoundTag nbt = this.stack.m_41784_();
        nbt.m_128405_("Filter-OPT", newOpts);
        this.stack.m_41751_(nbt);
        if (this.playerEntity.m_20193_().f_46443_) {
            SimplyBackpacks.NETWORK.sendToServer((Object)new FilterMessage(newOpts));
        }
        return newOpts;
    }

    public void saveFilter(int newOpts) {
        CompoundTag nbt = this.stack.m_41784_();
        nbt.m_128405_("Filter-OPT", newOpts);
        this.stack.m_41751_(nbt);
    }

    public void addPlayerSlots(Inventory playerInventory) {
        int originX = 7;
        int originY = 83;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = originX + col * 18;
                int y = originY + row * 18;
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, x + 1, y + 1));
            }
        }
        for (int col = 0; col < 9; ++col) {
            int x = originX + col * 18;
            int y = originY + 58;
            this.m_38897_(new Slot((Container)playerInventory, col, x + 1, y + 1));
        }
    }

    public boolean m_6366_(Player playerIn, int id) {
        if (this.m_142621_().m_41619_()) {
            this.filterHandler.removeItem(id);
        } else {
            ItemStack fake = this.m_142621_().m_41777_();
            fake.m_41764_(1);
            this.filterHandler.setItem(id, fake);
        }
        return true;
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player playerIn, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        for (int i = 0; i < this.filterHandler.getSlots(); ++i) {
            if (!this.filterHandler.getStackInSlot(i).m_41619_()) continue;
            ItemStack fake = slot.m_7993_().m_41777_();
            fake.m_41764_(1);
            this.filterHandler.setItem(i, fake);
            break;
        }
        return ItemStack.f_41583_;
    }
}

